/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.AutoUpdateGUI;
import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.UpgradeScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class LocalZipFileScreen
extends UpgradeScreen
implements ActionListener {
    private final String btnCancelCmd = "CANCEL";
    private final String btnBrowseCmd = "BROWSE";
    private final String btnNextCmd = "NEXT";
    private JTextField m_txtFilePath;
    private JFileChooser m_fChooser;
    private File m_currentDir = new File(".");

    public LocalZipFileScreen(String string, AutoUpdateGUI autoUpdateGUI) {
        super(string, autoUpdateGUI);
        this.configureJFrame(autoUpdateGUI);
    }

    protected void finalize() {
        System.out.println("Destroying Local Zip File ");
        super.finalize();
        this.m_fChooser = null;
        this.m_txtFilePath = null;
        this.m_currentDir = null;
    }

    private void configureJFrame(ActionListener actionListener) {
        Container container = super.getJFrame().getContentPane();
        JLabel jLabel = new JLabel("Please Specify the Location of the upgrade file on this Computer.");
        this.m_fChooser = new JFileChooser();
        this.m_fChooser.setDialogType(0);
        this.m_fChooser.setCurrentDirectory(this.m_currentDir);
        this.m_fChooser.setDialogTitle("Select The Upgrade File");
        this.m_fChooser.setFileSelectionMode(0);
        this.m_fChooser.setAcceptAllFileFilterUsed(false);
        this.m_fChooser.setMultiSelectionEnabled(false);
        this.m_fChooser.setToolTipText("Enter the Upgrade File on this Computer:");
        this.m_fChooser.setFileFilter(new UpgradeFileFilter());
        this.m_fChooser.requestFocusInWindow();
        JLabel jLabel2 = new JLabel("Upgrade Zip File: ");
        this.m_txtFilePath = new JTextField(30);
        this.m_txtFilePath.setToolTipText("Specify the Upgrade File");
        try {
            this.m_txtFilePath.setText(this.m_currentDir.getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.m_txtFilePath.requestFocusInWindow();
        jLabel2.setLabelFor(this.m_txtFilePath);
        this.m_txtFilePath.addFocusListener(this);
        this.m_txtFilePath.setPreferredSize(new Dimension(500, 50));
        JButton jButton = new JButton("Browse...");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('B');
        jButton.setActionCommand("BROWSE");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('C');
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(actionListener);
        JButton jButton3 = new JButton("Next >>");
        jButton3.setVerticalTextPosition(0);
        jButton3.setHorizontalTextPosition(10);
        jButton3.setMnemonic('N');
        jButton3.setDefaultCapable(true);
        jButton3.setActionCommand("NEXT");
        jButton3.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n = 4;
        int n2 = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(80, 0, n, 4);
        gridBagConstraints.anchor = 25;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        gridBagConstraints.anchor = 25;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        int n3 = 90;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 0, n3, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtFilePath, gridBagConstraints);
        jPanel.add(this.m_txtFilePath);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(0, 2, n3, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        JPanel jPanel3 = new JPanel();
        super.setLogo(jPanel3);
        container.add((Component)jPanel3, "First");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "Last");
        container.validate();
    }

    public int ScreenHandler(ActionEvent actionEvent, int n, Device88X device88X) {
        int n2 = n;
        int n3 = -1;
        if ("CANCEL".equals(actionEvent.getActionCommand())) {
            System.out.println("Exiting");
            System.exit(0);
        } else if (this.btnNextCmd.equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.m_currentDir = new File(this.m_txtFilePath.getText());
            if (!this.m_currentDir.exists() || !this.m_currentDir.isFile()) {
                Object[] objectArray = new Object[]{"Select A Different Upgrade File", "Cancel Upgrade"};
                String string = "File Does Not Exist, please select another Upgrade File";
                String string2 = "File Does Not Exist";
                if (!this.m_currentDir.isFile()) {
                    string = "Please Select a valid Upgrade File";
                    string2 = "Invalid Upgrade File";
                }
                n3 = JOptionPane.showOptionDialog(super.getJFrame(), string, string2, 1, 3, null, objectArray, objectArray[0]);
                switch (n3) {
                    case 0: {
                        n2 = n;
                        System.out.println("User will select new upgrade file: ID=" + n2);
                        break;
                    }
                    case 1: {
                        System.out.println("Exiting");
                        System.exit(0);
                    }
                }
            } else {
                n2 = 6;
                device88X.setLocalZipFileFlag(true);
                device88X.setZipFilePath(this.m_currentDir.getAbsolutePath());
                System.out.println("Upgrade File: " + device88X.getZipFilePath());
            }
        }
        System.out.println("Next State " + n2);
        return n2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if ("BROWSE".equals(actionEvent.getActionCommand()) && (n = this.m_fChooser.showDialog(super.getJFrame(), "Select")) == 0) {
            File file;
            this.m_currentDir = file = this.m_fChooser.getSelectedFile();
            this.m_txtFilePath.setText(file.getPath().toString());
        }
    }

    private class UpgradeFileFilter
    extends FileFilter {
        private UpgradeFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null) {
                return string.equalsIgnoreCase("ZIP");
            }
            return false;
        }

        public String getDescription() {
            return "Upgrade Zip File";
        }

        private String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }
}

